<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van MFMT_IN002320NL - Accept Act Reference Request</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>

    <include href="coreschematron/xml.sch"/>
    <include href="coreschematron/attentionLine.sch"/>
    
    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>
    
    <include href="VWI/MFMT_MT902000NL.sch"/>
    
    <!--pattern is-a="attentionLine" id="MFMT_IN002320NL-attentionLine">
        <param name="messagePatientId" value="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:subject2/hl7:ActReference/hl7:recordTarget/hl7:patient/hl7:id"/>
        <param name="attentionLineOptional" value="'false'"/>
        </pattern-->
    
    <pattern is-a="transmission-wrapper" id="MFMT_IN002320NL-wrapper">
        <param name="element" value="hl7:MFMT_IN002320NL"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="MFMT_IN002320NL-controlAct">
        <param name="element" value="hl7:MFMT_IN002320NL/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:MFMT_IN002320NL/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:MFMT_IN002320NL/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='NE'">In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</assert>
        </rule>
        <rule context="hl7:MFMT_IN002320NL/hl7:attentionLine">
            <assert role="warning" test="not(.)">Het gebruik van attentionLine wordt nog niet gespecificeerd in deze interactie.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>Zender en ontvanger</title>
        <rule context="hl7:MFMT_IN002320NL/hl7:sender/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and @extension='1'"
                >De zender van deze interactie moet de ZIM zijn</assert>
        </rule>
        <rule context="hl7:MFMT_IN002320NL/hl7:receiver/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and not(@extension='1')"
                >De ontvanger van deze interactie moet een AORTA applicatie zijn, en kan niet de ZIM zijn</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>acknowledgementType</title>
        <rule context="hl7:MFMT_IN002320NL/hl7:acknowledgement">
            <assert role="error" test="@typeCode='AA'"
                >acknowledgement/@typeCode moet bij een acceptatie-interactie 'AA' zijn</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>registrationProcess</title>
        <rule context="hl7:subject/hl7:registrationProcess">
            <assert role="error" test="not(@moodCode) or @moodCode='EVN'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/ActMood.htm#EVN"
                >registrationProcess/@moodCode moet 'EVN' zijn</assert>
            <assert role="error" test="count(hl7:subject2)=1"
                >registrationProcess/subject2 moet exact één maal voorkomen. Registraties van meer dan één Act zijn niet toegestaan</assert>
            <assert role="error" test="not(hl7:subject1)"
                >registrationProcess/subject1 is niet toegestaan in de Verwijsindex</assert>
            <assert role="error" test="hl7:id"
                >registrationProcess/id is verplicht bij acceptatie door de Verwijsindex</assert>
        </rule>
        
        <title>registrationProcess/statusCode</title>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:statusCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='active' or @code='nullified'"
                >registrationProcess/statuscode/@code moet 'active' of 'nullified' zijn.</assert>
        </rule>
        
        <title>registrationProcess/effectiveTime</title>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:effectiveTime">
            <extends rule="IVL_TS"/>
            <assert role="error" test="not(hl7:low/@nullFlavor) or hl7:low/@nullFlavor='UNK'"
                >registrationProcess/effectiveTime/low/@nullFlavor moet 'UNK' zijn</assert>
            <assert role="error" test="(../hl7:statusCode/@code='nullified' and hl7:high/@value) or not(hl7:high/@value)"
                >registrationProcess/effectiveTime/high/@value moet een waarde hebben als er een afmelding wordt geaccepteerd</assert>
        </rule>
    </pattern>
    
    <pattern is-a="MFMT_MT902000NL" id="MFMT_IN002320NL-MFMT_MT902000NL">
        <param name="element" value="hl7:ActReference"/>
    </pattern>
    
    <pattern>
        <title>Applicatie-id controle</title>
        <rule context="hl7:ActReference/hl7:custodian/hl7:assignedOrganization/hl7:telecom">
            <extends rule="TEL"/>
            <let name="receiverDeviceId" value="../../../../../../../../hl7:receiver/hl7:device/hl7:id[@root='2.16.840.1.113883.2.4.6.6']/@extension"/>
            
            <assert role="error" test="@value=concat('x-hl7-applicatie:2.16.840.1.113883.2.4.6.6.',$receiverDeviceId)"
                >assignedOrganization/telecom moet overeenkomen met de ontvanger van de acceptatieinteractie</assert>
        </rule>
    </pattern>
</schema>
